<?php $__env->startSection('page_title', __('label.channel_tv_shows')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('label.channel_tv_shows')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.channel_tv_shows')); ?></li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="<?php echo e(route('ch_tvshow.create')); ?>" class="btn btn-default mw-150" style="margin-top: -14px;"><?php echo e(__('label.add_tv_show')); ?></a>
                </div>
            </div>

            <!-- Search -->
            <div class="page-search mb-3">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                            <i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i>
                        </span>
                    </div>
                    <input type="text" id="input_search" class="form-control" placeholder="<?php echo e(__('label.search_tv_show')); ?>" aria-label="Search" aria-describedby="basic-addon1">
                </div>
                <div class="sorting mr-3" style="width: 60%;">
                    <label><?php echo e(__('label.sort_by')); ?></label>
                    <select class="form-control" id="input_channel">
                        <option value="0"><?php echo e(__('label.all_channel')); ?></option>
                        <?php for($i = 0; $i < count($channel); $i++): ?> 
                            <option value="<?php echo e($channel[$i]['id']); ?>" <?php if(isset($_GET['input_channel'])): ?><?php echo e($_GET['input_channel'] == $channel[$i]['id'] ? 'selected' : ''); ?> <?php endif; ?>>
                                <?php echo e($channel[$i]['name']); ?>

                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="sorting mr-3" style="width: 50%;">
                    <label><?php echo e(__('label.sort_by')); ?></label>
                    <select class="form-control" id="input_type">
                        <option value="0"><?php echo e(__('label.all_type')); ?></option>
                        <?php for($i = 0; $i < count($type); $i++): ?> 
                            <option value="<?php echo e($type[$i]['id']); ?>" <?php if(isset($_GET['input_type'])): ?><?php echo e($_GET['input_type'] == $type[$i]['id'] ? 'selected' : ''); ?> <?php endif; ?>>
                                <?php echo e($type[$i]['name']); ?>

                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="sorting mr-3" style="width: 40%;">
                    <label><?php echo e(__('label.sort_by')); ?></label>
                    <select class="form-control" name="input_rent" id="input_rent">
                        <option value="0" <?php if(isset($_GET['input_rent'])): ?><?php echo e($_GET['input_rent'] == 0 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.all_tv_show')); ?></option>
                        <option value="1" <?php if(isset($_GET['input_rent'])): ?><?php echo e($_GET['input_rent'] == 1 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.rent_tv_show')); ?></option>
                    </select>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-striped TVShow-table text-center table-bordered">
                    <thead>
                        <tr style="background: #F9FAFF;">
                            <th><?php echo e(__('label.#')); ?></th>
                            <th><?php echo e(__('label.image')); ?></th>
                            <th><?php echo e(__('label.name')); ?></th>
                            <th><?php echo e(__('label.type')); ?></th>
                            <th><?php echo e(__('label.episodes')); ?></th>
                            <th><?php echo e(__('label.status')); ?></th>
                            <th><?php echo e(__('label.action')); ?></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>

        // Sidebar Scroll Down
        sidebar_down(400);

        $("#input_channel").select2();

        $(document).ready(function() {
            var table = $('.TVShow-table').DataTable({
                dom: "<'top'f>rt<'row'<'col-2'i><'col-1'l><'col-9'p>>",
                searching: false,
                responsive: true,
                autoWidth: false,
                processing: true,
                serverSide: true,
                lengthMenu: [
                    [10, 100, 500, -1],
                    [10, 100, 500, "All"]
                ],
                language: {
                    paginate: {
                        previous: "<i class='fa-solid fa-chevron-left'></i>",
                        next: "<i class='fa-solid fa-chevron-right'></i>"
                    }
                },
                ajax: {
                    url: "<?php echo e(route('ch_tvshow.index')); ?>",
                    data: function(d) {
                        d.input_search = $('#input_search').val();
                        d.input_type = $('#input_type').val();
                        d.input_rent = $('#input_rent').val();
                        d.input_channel = $('#input_channel').val();
                    },
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'thumbnail',
                        name: 'thumbnail',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            return "<a href='" + data + "' target='_blank' title='<?php echo e(__('label.watch')); ?>'><img src='" + data + "' class='img-thumbnail' style='height:55px; width:55px'></a>";
                        },
                    },
                    {
                        data: 'name',
                        name: 'name',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'type.name',
                        name: 'type.name'
                    },
                    {
                        data: 'episode',
                        name: 'episode',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
            });

            $('#input_type, #input_rent, #input_channel').change(function(){
                table.draw();
            });
            $('#input_search').keyup(function() {
                table.draw();
            });
        });

        function change_status(id, status) {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var url = "<?php echo e(route('ch_tvshow.show', '')); ?>" + "/" + id;
                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: id,
                    success: function(resp) {
                        $("#dvloader").hide();
                        if (resp.status == 200) {
                            if (resp.Status_Code == 1) {

                                $('#' + id).text('<?php echo e(__("label.show")); ?>');
                                $('#' + id).css({
                                    "background": "#058f00",
                                    "font-weight":"bold",
                                    "color": "white",
                                    "border": "none",
                                    "outline": "none",
                                    "padding": "5px 15px",
                                    "border-radius": "5px",
                                    "cursor": "pointer",
                                });
                            } else {

                                $('#' + id).text('<?php echo e(__("label.hide")); ?>');
                                $('#' + id).css({
                                    "background": "#e3000b",
                                    "color": "white",
                                    "border": "none",
                                    "outline": "none",
                                    "padding": "5px 20px",
                                    "border-radius": "5px",
                                    "cursor": "pointer",
                                });
                            }
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        };
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/admin/channel_tv_show/index.blade.php ENDPATH**/ ?>