
<?php $__env->startSection('page_title', __('label.comment')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('label.comment')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.comment')); ?></li>
                    </ol>
                </div>
            </div>

            <!-- Search -->
            <div class="page-search mb-3">
                <div class="input-group" title="<?php echo e(__('label.search')); ?>">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i></span>
                    </div>
                    <input type="text" id="input_search" class="form-control" placeholder="Search Comment" aria-label="Search" aria-describedby="basic-addon1">
                </div>
                <div class="sorting mr-2" style="width: 50%;">
                    <label><?php echo e(__('label.sort_by')); ?></label>
                    <select class="form-control" name="input_user" id="input_user">
                        <option value="0" selected><?php echo e(__('label.all_user')); ?></option>
                        <?php for($i = 0; $i < count($user); $i++): ?> <option value="<?php echo e($user[$i]['id']); ?>" <?php if(isset($_GET['input_user'])): ?><?php echo e($_GET['input_user'] == $user[$i]['id'] ? 'selected' : ''); ?> <?php endif; ?>>
                            <?php echo e($user[$i]['user_name']); ?>

                            </option>
                            <?php endfor; ?>
                    </select>
                </div>
                <div class="sorting mr-2" style="width: 30%;">
                    <label><?php echo e(__('label.sort_by')); ?></label>
                    <select class="form-control" name="input_video_type" id="input_video_type">
                        <option value="0"><?php echo e(__('label.all_type')); ?></option>
                        <option value="1" <?php if(isset($_GET['input_video_type'])): ?><?php echo e($_GET['input_video_type'] == 1 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.video')); ?></option>
                        <option value="2" <?php if(isset($_GET['input_video_type'])): ?><?php echo e($_GET['input_video_type'] == 2 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.tv_show')); ?></option>
                        <option value="5" <?php if(isset($_GET['input_video_type'])): ?><?php echo e($_GET['input_video_type'] == 5 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.upcoming')); ?></option>
                        <option value="6" <?php if(isset($_GET['input_video_type'])): ?><?php echo e($_GET['input_video_type'] == 6 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.channel')); ?></option>
                        <option value="7" <?php if(isset($_GET['input_video_type'])): ?><?php echo e($_GET['input_video_type'] == 6 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.kids')); ?></option>
                    </select>
                </div>
            </div>

            <div class="table-responsive table">
                <table class="table table-striped text-center table-bordered" id="datatable">
                    <thead>
                        <tr style="background: #F9FAFF;">
                            <th><?php echo e(__('label.#')); ?></th>
                            <th><?php echo e(__('label.user')); ?></th>
                            <th><?php echo e(__('label.content_type')); ?></th>
                            <th><?php echo e(__('label.content')); ?></th>
                            <th><?php echo e(__('label.comment')); ?></th>
                            <th><?php echo e(__('label.date')); ?></th>
                            <th><?php echo e(__('label.action')); ?></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>

        // Sidebar Scroll Down
        sidebar_down($(document).height());

        $("#input_user").select2();

        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                dom: "<'top'f>rt<'row'<'col-2'i><'col-1'l><'col-9'p>>",
                searching: false,
                responsive: true,
                autoWidth: false,
                processing: true,
                serverSide: true,
                lengthMenu: [
                    [10, 100, 500, -1],
                    [10, 100, 500, "All"]
                ],
                language: {
                    paginate: {
                        previous: "<i class='fa-solid fa-chevron-left'></i>",
                        next: "<i class='fa-solid fa-chevron-right'></i>"
                    }
                },
                ajax: {
                    url: "<?php echo e(route('comment.index')); ?>",
                    data: function(d) {
                        d.input_search = $('#input_search').val();
                        d.input_user = $('#input_user').val();
                        d.input_video_type = $('#input_video_type').val();
                    },
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'user.user_name',
                        name: 'user.user_name',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'video_type',
                        name: 'video_type',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data == 1) {
                                return "<?php echo e(__('label.video')); ?>";
                            } else if (data == 2) {
                                return "<?php echo e(__('label.tv_show')); ?>";
                            } else if (data == 5) {
                                return "<?php echo e(__('label.upcoming')); ?>";
                            } else if (data == 6) {
                                return "<?php echo e(__('label.channel')); ?>";
                            } else if (data == 7) {
                                return "<?php echo e(__('label.kids')); ?>";
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'video_name',
                        name: 'video_name',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'comment',
                        name: 'comment',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
            });

            $('#input_user, #input_video_type').change(function() {
                table.draw();
            });
            $('#input_search').keyup(function() {
                table.draw();
            });
        });

        function change_status(id, status) {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var url = "<?php echo e(route('comment.show', '')); ?>" + "/" + id;
                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: id,
                    success: function(resp) {
                        $("#dvloader").hide();
                        if (resp.status == 200) {
                            if (resp.Status_Code == 1) {

                                $('#' + id).text("<?php echo e(__('label.show')); ?>");
                                $('#' + id).css({
                                    "background": "#058f00",
                                    "font-weight": "bold",
                                    "color": "white",
                                    "border": "none",
                                    "outline": "none",
                                    "padding": "5px 15px",
                                    "border-radius": "5px",
                                    "cursor": "pointer",
                                });
                            } else {

                                $('#' + id).text("<?php echo e(__('label.hide')); ?>");
                                $('#' + id).css({
                                    "background": "#e3000b",
                                    "color": "white",
                                    "border": "none",
                                    "outline": "none",
                                    "padding": "5px 20px",
                                    "border-radius": "5px",
                                    "cursor": "pointer",
                                });
                            }
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown.msg, '<?php echo e(__("label.failed")); ?>');
                    }
                });

            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        };
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/admin/comment/index.blade.php ENDPATH**/ ?>