<?php $__env->startSection('page_title', __('label.channel_videos')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('producer.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('producer.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('label.channel_videos')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('producer.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.channel_videos')); ?></li>
                    </ol>
                </div>
            </div>

            <!-- Search -->
            <form action="<?php echo e(route('pch_video.index')); ?>" method="GET">
                <div class="page-search mb-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                                <i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i>
                            </span>
                        </div>
                        <input type="text" name="input_search" value="<?php if(isset($_GET['input_search'])): ?><?php echo e($_GET['input_search']); ?><?php endif; ?>" class="form-control" placeholder="<?php echo e(__('label.search_videos')); ?>" aria-label="Search" aria-describedby="basic-addon1">
                    </div>
                    <div class="sorting mr-3" style="width: 60%;">
                        <label><?php echo e(__('label.sort_by')); ?></label>
                        <select class="form-control" name="input_channel" id="input_channel">
                            <option value="0" selected><?php echo e(__('label.all_channel')); ?></option>
                            <?php for($i = 0; $i < count($channel); $i++): ?> 
                                <option value="<?php echo e($channel[$i]['id']); ?>" <?php if(isset($_GET['input_channel'])): ?><?php echo e($_GET['input_channel'] == $channel[$i]['id'] ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e($channel[$i]['name']); ?>

                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="sorting mr-3" style="width: 50%;">
                        <label><?php echo e(__('label.sort_by')); ?></label>
                        <select class="form-control" name="input_type">
                            <option value="0" selected><?php echo e(__('label.all_type')); ?></option>
                            <?php for($i = 0; $i < count($type); $i++): ?> 
                                <option value="<?php echo e($type[$i]['id']); ?>" <?php if(isset($_GET['input_type'])): ?><?php echo e($_GET['input_type'] == $type[$i]['id'] ? 'selected' : ''); ?> <?php endif; ?>>
                                    <?php echo e($type[$i]['name']); ?>

                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="sorting" style="width: 40%;">
                        <label><?php echo e(__('label.sort_by')); ?></label>
                        <select class="form-control" name="input_rent">
                            <option value="0" <?php if(isset($_GET['input_rent'])): ?><?php echo e($_GET['input_rent'] == 0 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.all_video')); ?></option>
                            <option value="1" <?php if(isset($_GET['input_rent'])): ?><?php echo e($_GET['input_rent'] == 1 ? 'selected' : ''); ?> <?php endif; ?>><?php echo e(__('label.rent_video')); ?></option>
                        </select>
                    </div>
                    <div class="mr-3 ml-5">
                        <button class="btn btn-default" type="submit"><?php echo e(__('label.search')); ?></button>
                    </div>
                </div>
            </form>

            <div class="row">
                <div class="col-12 col-sm-6 col-md-4 col-xl-3" title="<?php echo e(__('label.add_video')); ?>">
                    <a href="<?php echo e(route('pch_video.create')); ?>" class="add-video-btn">
                        <i class="fa-regular fa-square-plus fa-3x icon" style="color: #818181;"></i>
                        <?php echo e(__('label.add_new_video')); ?>

                    </a>
                </div>

                <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-sm-6 col-md-4 col-xl-3">
                    <div class="card video-card">
                        <div class="position-relative">

                            <?php if($value->is_premium == 1): ?>
                                <div class="ribbon ribbon-top-left"><span><?php echo e(__('label.premium')); ?></span></div>
                            <?php endif; ?>

                            <img class="card-img-top" src="<?php echo e($value->thumbnail); ?>" alt="">
                            <?php if($value->video_upload_type == "server_video"): ?>
                            <button class="btn play-btn-top video" data-toggle="modal" data-target="#videoModal" data-video="<?php echo e($value->video_320); ?>" data-image="<?php echo e($value->landscape); ?>">
                                <i class="fa-regular fa-circle-play text-white fa-4x mr-2 mt-2"></i>
                            </button>
                            <?php endif; ?>

                            <ul class="list-inline overlap-control" aria-labelledby="dropdownMenuLink">
                                <li class="list-inline-item">
                                    <a class="btn" href="<?php echo e(route('pch_video.details', [$value->id])); ?>" title="<?php echo e(__('label.statistics')); ?>">
                                        <i class="fa-solid fa-chart-line fa-xl" class="dot-icon" style="color: #4e45b8;"></i>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn" href="<?php echo e(route('pch_video.edit', [$value->id])); ?>" title="<?php echo e(__('label.edit')); ?>">
                                        <i class="fa-solid fa-pen-to-square fa-xl" class="dot-icon" style="color: #4e45b8;"></i>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn" href="<?php echo e(route('pch_video.show', [$value->id])); ?>" title="<?php echo e(__('label.delete')); ?>" onclick="return confirm('<?php echo e(__('label.delete_video')); ?>')">
                                        <i class="fa-solid fa-trash-can fa-xl" class="dot-icon" style="color: #4e45b8;"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <h5 class="card-title"><?php echo e($value->name); ?></h5>
                            <div class="d-flex justify-content-between">
                                <?php if($value->status == 1): ?>
                                <button class="btn btn-sm" style="background:#058f00; font-weight:bold; border: none; color: white;"><?php echo e(__('label.show')); ?></button>
                                <?php elseif($value->status == 0): ?>
                                <button class="btn btn-sm" style="background:#e3000b; font-weight:bold; border: none; color: white;"><?php echo e(__('label.hide')); ?></button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Model -->
            <div class="modal fade" id="videoModal" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg">
                    <div class="modal-content">
                        <div class="modal-body p-0 bg-transparent">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true" class="text-dark">&times;</span>
                            </button>
                            <video controls width="800" height="500" preload='none' poster="" id="theVideo" controlsList="nodownload noplaybackrate" disablepictureinpicture>
                                <source src="" type="video/mp4">
                            </video>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center">
                <div> Showing <?php echo e($result->firstItem()); ?> to <?php echo e($result->lastItem()); ?> of total <?php echo e($result->total()); ?> entries </div>
                <div class="pb-5"> <?php echo e($result->links()); ?> </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>
        $("#input_channel").select2();

        $(function() {
            $(".video").click(function() {
                var theModal = $(this).data("target"),
                    videoSRC = $(this).attr("data-video"),
                    videoPoster = $(this).attr("data-image"),
                    videoSRCauto = videoSRC + "";

                $(theModal + ' source').attr('src', videoSRCauto);
                $(theModal + ' video').attr('poster', videoPoster);
                $(theModal + ' video').load();
                $(theModal + ' button.close').click(function() {
                    $(theModal + ' source').attr('src', videoSRC);
                });
            });
        });
        $("#videoModal .close").click(function() {
            theVideo.pause()
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('producer.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/producer/channel_video/index.blade.php ENDPATH**/ ?>